/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Queue;
import javax.vecmath.Point3d;
import replicatorg.app.Base;
import replicatorg.app.GCode;
import replicatorg.app.exceptions.GCodeException;
import replicatorg.drivers.DriverQueryInterface;
import replicatorg.drivers.MultiTool;
import replicatorg.drivers.commands.ChangeGearRatio;
import replicatorg.drivers.commands.CloseClamp;
import replicatorg.drivers.commands.CloseCollet;
import replicatorg.drivers.commands.CloseValve;
import replicatorg.drivers.commands.Delay;
import replicatorg.drivers.commands.DisableDrives;
import replicatorg.drivers.commands.DisableFan;
import replicatorg.drivers.commands.DisableFloodCoolant;
import replicatorg.drivers.commands.DisableMistCoolant;
import replicatorg.drivers.commands.DisableMotor;
import replicatorg.drivers.commands.DisableSpindle;
import replicatorg.drivers.commands.DriverCommand;
import replicatorg.drivers.commands.EnableDrives;
import replicatorg.drivers.commands.EnableFan;
import replicatorg.drivers.commands.EnableFloodCoolant;
import replicatorg.drivers.commands.EnableMistCoolant;
import replicatorg.drivers.commands.EnableMotor;
import replicatorg.drivers.commands.EnableSpindle;
import replicatorg.drivers.commands.GCodePassthrough;
import replicatorg.drivers.commands.GetPosition;
import replicatorg.drivers.commands.HomeAxes;
import replicatorg.drivers.commands.Initialize;
import replicatorg.drivers.commands.OpenClamp;
import replicatorg.drivers.commands.OpenCollet;
import replicatorg.drivers.commands.OpenValve;
import replicatorg.drivers.commands.OptionalHalt;
import replicatorg.drivers.commands.ProgramEnd;
import replicatorg.drivers.commands.ProgramRewind;
import replicatorg.drivers.commands.QueuePoint;
import replicatorg.drivers.commands.ReadTemperature;
import replicatorg.drivers.commands.RecallHomePositions;
import replicatorg.drivers.commands.RequestToolChange;
import replicatorg.drivers.commands.SelectTool;
import replicatorg.drivers.commands.SetAxisOffset;
import replicatorg.drivers.commands.SetChamberTemperature;
import replicatorg.drivers.commands.SetCurrentPosition;
import replicatorg.drivers.commands.SetFeedrate;
import replicatorg.drivers.commands.SetMotorDirection;
import replicatorg.drivers.commands.SetMotorSpeedPWM;
import replicatorg.drivers.commands.SetMotorSpeedRPM;
import replicatorg.drivers.commands.SetPlatformTemperature;
import replicatorg.drivers.commands.SetServo;
import replicatorg.drivers.commands.SetSpindleDirection;
import replicatorg.drivers.commands.SetSpindleRPM;
import replicatorg.drivers.commands.SetTemperature;
import replicatorg.drivers.commands.StoreHomePositions;
import replicatorg.drivers.commands.UnconditionalHalt;
import replicatorg.drivers.commands.WaitUntilBufferEmpty;
import replicatorg.machine.model.AxisId;
import replicatorg.util.Point5d;

public class GCodeParser {
    protected DriverQueryInterface driver;
    DrillCycle drillCycle;
    public static double curveSectionMM = Base.preferences.getDouble("replicatorg.parser.curve_segment_mm", 1.0);
    public static double curveSectionInches = curveSectionMM / 25.4;
    protected double curveSection = 0.0;
    protected Point3d currentOffset;
    boolean absoluteMode = false;
    double feedrate = 0.0;
    protected int tool = -1;
    public static int UNITS_MM = 0;
    public static int UNITS_INCHES = 1;
    protected int units = UNITS_MM;

    Queue<DriverCommand> drawArc(Point5d center, Point5d endpoint, boolean clockwise) {
        double angleB;
        double angleA;
        LinkedList<DriverCommand> points = new LinkedList<DriverCommand>();
        Point5d current = this.driver.getCurrentPosition(false);
        double aX = current.x() - center.x();
        double aY = current.y() - center.y();
        double bX = endpoint.x() - center.x();
        double bY = endpoint.y() - center.y();
        if (clockwise) {
            angleA = Math.atan2(bY, bX);
            angleB = Math.atan2(aY, aX);
        } else {
            angleA = Math.atan2(aY, aX);
            angleB = Math.atan2(bY, bX);
        }
        if (angleB <= angleA) {
            angleB += Math.PI * 2;
        }
        double angle = angleB - angleA;
        double radius = Math.sqrt(aX * aX + aY * aY);
        double length = radius * angle;
        int steps = (int)Math.ceil(Math.max(angle * 2.4, length / this.curveSection));
        Point5d newPoint = new Point5d(current);
        double arcStartZ = current.z();
        int s = 1;
        while (s <= steps) {
            int step = !clockwise ? s : steps - s;
            newPoint.setX(center.x() + radius * Math.cos(angleA + angle * ((double)step / (double)steps)));
            newPoint.setY(center.y() + radius * Math.sin(angleA + angle * ((double)step / (double)steps)));
            newPoint.setZ(arcStartZ + (endpoint.z() - arcStartZ) * (double)s / (double)steps);
            points.add(new QueuePoint(newPoint));
            ++s;
        }
        return points;
    }

    public GCodeParser() {
        this.curveSection = curveSectionMM;
        this.currentOffset = new Point3d();
    }

    protected double getMaxFeedrate() {
        return this.driver.getMaximumFeedrates().x();
    }

    public void init(DriverQueryInterface drv) {
        this.driver = drv;
        this.currentOffset = this.driver.getOffset(0);
        this.drillCycle = new DrillCycle();
    }

    public boolean parse(String cmd, Queue<DriverCommand> commandQueue) {
        GCode gcode = new GCode(cmd);
        if (this.driver.isPassthroughDriver()) {
            commandQueue.add(new GCodePassthrough(gcode.getCommand()));
        } else {
            try {
                if (gcode.hasCode('G')) {
                    this.buildGCodes(gcode, commandQueue);
                } else if (gcode.hasCode('M')) {
                    this.buildMCodes(gcode, commandQueue);
                }
            }
            catch (GCodeException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private double convertToMM(double value, int units) {
        if (units == UNITS_INCHES) {
            return value * 25.4;
        }
        return value;
    }

    private void buildMCodes(GCode gcode, Queue<DriverCommand> commands) throws GCodeException {
        if (gcode.hasCode('T') && this.driver instanceof MultiTool && ((MultiTool)((Object)this.driver)).supportsSimultaneousTools()) {
            commands.add(new SelectTool((int)gcode.getCodeValue('T')));
        }
        switch ((int)gcode.getCodeValue('M')) {
            case 0: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new UnconditionalHalt(gcode.getComment()));
                break;
            }
            case 1: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new OptionalHalt(gcode.getComment()));
                break;
            }
            case 2: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new ProgramEnd(gcode.getComment()));
                break;
            }
            case 30: {
                commands.add(new WaitUntilBufferEmpty());
                commands.add(new ProgramRewind(gcode.getComment()));
                break;
            }
            case 3: {
                commands.add(new SetSpindleDirection(DriverCommand.AxialDirection.CLOCKWISE));
                commands.add(new EnableSpindle());
                break;
            }
            case 4: {
                commands.add(new SetSpindleDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE));
                commands.add(new EnableSpindle());
                break;
            }
            case 5: {
                commands.add(new DisableSpindle());
                break;
            }
            case 6: {
                int timeout = 65535;
                if (gcode.hasCode('P')) {
                    timeout = (int)gcode.getCodeValue('P');
                }
                if (gcode.hasCode('T')) {
                    commands.add(new RequestToolChange((int)gcode.getCodeValue('T'), timeout));
                    break;
                }
                throw new GCodeException("The T parameter is required for tool changes. (M6)");
            }
            case 7: {
                commands.add(new EnableFloodCoolant());
                break;
            }
            case 8: {
                commands.add(new EnableMistCoolant());
                break;
            }
            case 9: {
                commands.add(new DisableFloodCoolant());
                commands.add(new DisableMistCoolant());
                break;
            }
            case 10: {
                if (gcode.hasCode('Q')) {
                    commands.add(new CloseClamp((int)gcode.getCodeValue('Q')));
                    break;
                }
                throw new GCodeException("The Q parameter is required for clamp operations. (M10)");
            }
            case 11: {
                if (gcode.hasCode('Q')) {
                    commands.add(new OpenClamp((int)gcode.getCodeValue('Q')));
                    break;
                }
                throw new GCodeException("The Q parameter is required for clamp operations. (M11)");
            }
            case 13: {
                commands.add(new SetSpindleDirection(DriverCommand.AxialDirection.CLOCKWISE));
                commands.add(new EnableSpindle());
                commands.add(new EnableFloodCoolant());
                break;
            }
            case 14: {
                commands.add(new SetSpindleDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE));
                commands.add(new EnableSpindle());
                commands.add(new EnableFloodCoolant());
                break;
            }
            case 17: {
                commands.add(new EnableDrives());
                break;
            }
            case 18: {
                commands.add(new DisableDrives());
                break;
            }
            case 21: {
                commands.add(new OpenCollet());
                break;
            }
            case 22: {
                commands.add(new CloseCollet());
                break;
            }
            case 40: {
                commands.add(new ChangeGearRatio(0));
                break;
            }
            case 41: {
                commands.add(new ChangeGearRatio(1));
                break;
            }
            case 42: {
                commands.add(new ChangeGearRatio(2));
                break;
            }
            case 43: {
                commands.add(new ChangeGearRatio(3));
                break;
            }
            case 44: {
                commands.add(new ChangeGearRatio(4));
                break;
            }
            case 45: {
                commands.add(new ChangeGearRatio(5));
                break;
            }
            case 46: {
                commands.add(new ChangeGearRatio(6));
                break;
            }
            case 50: {
                this.driver.getSpindleRPM();
                break;
            }
            case 101: {
                commands.add(new SetMotorDirection(DriverCommand.AxialDirection.CLOCKWISE));
                commands.add(new EnableMotor());
                break;
            }
            case 102: {
                commands.add(new SetMotorDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE));
                commands.add(new EnableMotor());
                break;
            }
            case 103: {
                commands.add(new DisableMotor());
                break;
            }
            case 104: {
                if (!gcode.hasCode('S')) break;
                commands.add(new SetTemperature(gcode.getCodeValue('S')));
                break;
            }
            case 105: {
                commands.add(new ReadTemperature());
                break;
            }
            case 106: {
                commands.add(new EnableFan());
                break;
            }
            case 107: {
                commands.add(new DisableFan());
                break;
            }
            case 108: {
                if (gcode.hasCode('S')) {
                    commands.add(new SetMotorSpeedPWM((int)gcode.getCodeValue('S')));
                    break;
                }
                if (!gcode.hasCode('R')) break;
                commands.add(new SetMotorSpeedRPM(gcode.getCodeValue('R')));
                break;
            }
            case 109: {
                if (!gcode.hasCode('S')) break;
                commands.add(new SetPlatformTemperature(gcode.getCodeValue('S')));
                break;
            }
            case 110: {
                commands.add(new SetChamberTemperature(gcode.getCodeValue('S')));
            }
            case 126: {
                commands.add(new OpenValve());
                break;
            }
            case 127: {
                commands.add(new CloseValve());
                break;
            }
            case 128: {
                commands.add(new GetPosition());
                break;
            }
            case 131: {
                EnumSet<AxisId> axes = EnumSet.noneOf(AxisId.class);
                if (gcode.hasCode('X')) {
                    axes.add(AxisId.X);
                }
                if (gcode.hasCode('Y')) {
                    axes.add(AxisId.Y);
                }
                if (gcode.hasCode('Z')) {
                    axes.add(AxisId.Z);
                }
                if (gcode.hasCode('A')) {
                    axes.add(AxisId.A);
                }
                if (gcode.hasCode('B')) {
                    axes.add(AxisId.B);
                }
                commands.add(new StoreHomePositions(axes));
                break;
            }
            case 132: {
                EnumSet<AxisId> axes = EnumSet.noneOf(AxisId.class);
                if (gcode.hasCode('X')) {
                    axes.add(AxisId.X);
                }
                if (gcode.hasCode('Y')) {
                    axes.add(AxisId.Y);
                }
                if (gcode.hasCode('Z')) {
                    axes.add(AxisId.Z);
                }
                if (gcode.hasCode('A')) {
                    axes.add(AxisId.A);
                }
                if (gcode.hasCode('B')) {
                    axes.add(AxisId.B);
                }
                commands.add(new RecallHomePositions(axes));
                commands.add(new WaitUntilBufferEmpty());
                break;
            }
            case 200: {
                commands.add(new Initialize());
                break;
            }
            case 300: {
                if (!gcode.hasCode('S')) break;
                commands.add(new SetServo(0, gcode.getCodeValue('S')));
                break;
            }
            case 301: {
                if (!gcode.hasCode('S')) break;
                commands.add(new SetServo(1, gcode.getCodeValue('S')));
                break;
            }
            default: {
                throw new GCodeException("Unknown M code: M" + (int)gcode.getCodeValue('M'));
            }
        }
    }

    private void buildGCodes(GCode gcode, Queue<DriverCommand> commands) throws GCodeException {
        if (!gcode.hasCode('G')) {
            throw new GCodeException("Not a G code!");
        }
        Point5d temp = this.driver.getCurrentPosition(false);
        double iVal = this.convertToMM(gcode.getCodeValue('I'), this.units);
        double jVal = this.convertToMM(gcode.getCodeValue('J'), this.units);
        double kVal = this.convertToMM(gcode.getCodeValue('K'), this.units);
        double qVal = this.convertToMM(gcode.getCodeValue('Q'), this.units);
        double rVal = this.convertToMM(gcode.getCodeValue('R'), this.units);
        double xVal = this.convertToMM(gcode.getCodeValue('X'), this.units);
        double yVal = this.convertToMM(gcode.getCodeValue('Y'), this.units);
        double zVal = this.convertToMM(gcode.getCodeValue('Z'), this.units);
        double aVal = this.convertToMM(gcode.getCodeValue('A'), this.units);
        double bVal = this.convertToMM(gcode.getCodeValue('B'), this.units);
        double eVal = this.convertToMM(gcode.getCodeValue('E'), this.units);
        xVal += this.currentOffset.x;
        yVal += this.currentOffset.y;
        zVal += this.currentOffset.z;
        if (this.absoluteMode) {
            if (gcode.hasCode('X')) {
                temp.setX(xVal);
            }
            if (gcode.hasCode('Y')) {
                temp.setY(yVal);
            }
            if (gcode.hasCode('Z')) {
                temp.setZ(zVal);
            }
            if (gcode.hasCode('A')) {
                temp.setA(aVal);
            }
            if (gcode.hasCode('E')) {
                if (this.tool == 0) {
                    temp.setA(eVal);
                } else if (this.tool == 1) {
                    temp.setB(eVal);
                }
            }
            if (gcode.hasCode('B')) {
                temp.setB(bVal);
            }
        } else {
            if (gcode.hasCode('X')) {
                temp.setX(temp.x() + xVal);
            }
            if (gcode.hasCode('Y')) {
                temp.setY(temp.y() + yVal);
            }
            if (gcode.hasCode('Z')) {
                temp.setZ(temp.z() + zVal);
            }
            if (gcode.hasCode('A')) {
                temp.setA(temp.a() + aVal);
            }
            if (gcode.hasCode('E')) {
                if (this.tool == 0) {
                    temp.setA(temp.a() + eVal);
                } else if (this.tool == 1) {
                    temp.setB(temp.b() + eVal);
                }
            }
            if (gcode.hasCode('B')) {
                temp.setB(temp.b() + bVal);
            }
        }
        if (gcode.hasCode('F')) {
            this.feedrate = gcode.getCodeValue('F');
            commands.add(new SetFeedrate(this.feedrate));
        }
        int gCode = (int)gcode.getCodeValue('G');
        switch (gCode) {
            case 0: {
                commands.add(new SetFeedrate(this.feedrate));
                commands.add(new QueuePoint(temp));
                break;
            }
            case 1: {
                commands.add(new SetFeedrate(this.feedrate));
                commands.add(new QueuePoint(temp));
                break;
            }
            case 2: 
            case 3: {
                if (gcode.hasCode('I') || gcode.hasCode('J')) {
                    Point5d center = new Point5d();
                    Point5d current = this.driver.getCurrentPosition(false);
                    center.setX(current.x() + iVal);
                    center.setY(current.y() + jVal);
                    if (gCode == 2) {
                        commands.addAll(this.drawArc(center, temp, true));
                        break;
                    }
                    commands.addAll(this.drawArc(center, temp, false));
                    break;
                }
                if (!gcode.hasCode('R')) break;
                throw new GCodeException("G02/G03 arcs with (R)adius parameter are not supported yet.");
            }
            case 4: {
                commands.add(new Delay((long)gcode.getCodeValue('P')));
                break;
            }
            case 10: {
                if (gcode.hasCode('P')) {
                    int offsetSystemNum = (int)gcode.getCodeValue('P');
                    if (offsetSystemNum < 1 || offsetSystemNum > 6) break;
                    if (gcode.hasCode('X')) {
                        commands.add(new SetAxisOffset(AxisId.X, offsetSystemNum, gcode.getCodeValue('X')));
                    }
                    if (gcode.hasCode('Y')) {
                        commands.add(new SetAxisOffset(AxisId.Y, offsetSystemNum, gcode.getCodeValue('Y')));
                    }
                    if (!gcode.hasCode('Z')) break;
                    commands.add(new SetAxisOffset(AxisId.Z, offsetSystemNum, gcode.getCodeValue('Z')));
                    break;
                }
                Base.logger.warning("No coordinate system indicated use G10 Pn, where n is 0-6.");
                break;
            }
            case 20: 
            case 70: {
                this.units = UNITS_INCHES;
                this.curveSection = curveSectionInches;
                break;
            }
            case 21: 
            case 71: {
                this.units = UNITS_MM;
                this.curveSection = curveSectionMM;
                break;
            }
            case 28: {
                EnumSet<AxisId> axes = EnumSet.noneOf(AxisId.class);
                if (gcode.hasCode('X')) {
                    axes.add(AxisId.X);
                }
                if (gcode.hasCode('Y')) {
                    axes.add(AxisId.Y);
                }
                if (gcode.hasCode('Z')) {
                    axes.add(AxisId.Z);
                }
                if (gcode.hasCode('F')) {
                    commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.POSITIVE, this.feedrate));
                    break;
                }
                commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.POSITIVE));
                break;
            }
            case 161: {
                EnumSet<AxisId> axes = EnumSet.noneOf(AxisId.class);
                if (gcode.hasCode('X')) {
                    axes.add(AxisId.X);
                }
                if (gcode.hasCode('Y')) {
                    axes.add(AxisId.Y);
                }
                if (gcode.hasCode('Z')) {
                    axes.add(AxisId.Z);
                }
                if (gcode.hasCode('F')) {
                    commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.NEGATIVE, this.feedrate));
                    break;
                }
                commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.NEGATIVE));
                break;
            }
            case 162: {
                EnumSet<AxisId> axes = EnumSet.noneOf(AxisId.class);
                if (gcode.hasCode('X')) {
                    axes.add(AxisId.X);
                }
                if (gcode.hasCode('Y')) {
                    axes.add(AxisId.Y);
                }
                if (gcode.hasCode('Z')) {
                    axes.add(AxisId.Z);
                }
                if (gcode.hasCode('F')) {
                    commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.POSITIVE, this.feedrate));
                    break;
                }
                commands.add(new HomeAxes(axes, DriverCommand.LinearDirection.POSITIVE));
                break;
            }
            case 53: {
                this.currentOffset = this.driver.getOffset(0);
                break;
            }
            case 54: {
                this.currentOffset = this.driver.getOffset(1);
                break;
            }
            case 55: {
                this.currentOffset = this.driver.getOffset(2);
                break;
            }
            case 56: {
                this.currentOffset = this.driver.getOffset(3);
                break;
            }
            case 57: {
                this.currentOffset = this.driver.getOffset(4);
                break;
            }
            case 58: {
                this.currentOffset = this.driver.getOffset(5);
                break;
            }
            case 59: {
                this.currentOffset = this.driver.getOffset(6);
                break;
            }
            case 80: {
                this.drillCycle.setRetract(0.0);
                this.drillCycle.setFeedrate(0.0);
                this.drillCycle.setDwell(0);
                this.drillCycle.setPecksize(0.0);
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 183: {
                boolean speedPeck = false;
                this.drillCycle.setTarget(temp);
                if (gcode.hasCode('F')) {
                    this.drillCycle.setFeedrate(gcode.getCodeValue('F'));
                }
                if (gcode.hasCode('R')) {
                    this.drillCycle.setFeedrate(rVal);
                }
                if (gCode == 81) {
                    this.drillCycle.setDwell(0);
                    this.drillCycle.setPecksize(0.0);
                } else if (gCode == 82) {
                    if (gcode.hasCode('P')) {
                        this.drillCycle.setDwell((int)gcode.getCodeValue('P'));
                    }
                    this.drillCycle.setPecksize(0.0);
                } else if (gCode == 83 || gCode == 183) {
                    if (gcode.hasCode('P')) {
                        this.drillCycle.setDwell((int)gcode.getCodeValue('P'));
                    }
                    if (gcode.hasCode('Q')) {
                        this.drillCycle.setPecksize(Math.abs(gcode.getCodeValue('Q')));
                    }
                    if (gCode == 183) {
                        speedPeck = true;
                    }
                }
                this.drillCycle.doDrill(speedPeck);
                break;
            }
            case 90: {
                this.absoluteMode = true;
                break;
            }
            case 91: {
                this.absoluteMode = false;
                break;
            }
            case 92: {
                Point5d current = this.driver.getCurrentPosition(false);
                if (gcode.hasCode('X')) {
                    current.setX(xVal);
                }
                if (gcode.hasCode('Y')) {
                    current.setY(yVal);
                }
                if (gcode.hasCode('Z')) {
                    current.setZ(zVal);
                }
                if (gcode.hasCode('A')) {
                    current.setA(aVal);
                }
                if (gcode.hasCode('E')) {
                    current.setA(eVal);
                }
                if (gcode.hasCode('B')) {
                    current.setB(bVal);
                }
                commands.add(new SetCurrentPosition(current));
                break;
            }
            case 94: {
                break;
            }
            case 97: {
                commands.add(new SetSpindleRPM(gcode.getCodeValue('S')));
                break;
            }
            default: {
                throw new GCodeException("Unknown G code: G" + (int)gcode.getCodeValue('G'));
            }
        }
    }

    private class DrillCycle {
        private Point5d target = new Point5d();
        private double retract = 0.0;
        private double feedrate = 0.0;
        private int dwell = 0;
        private double pecksize = 0.0;

        DrillCycle() {
        }

        public void setTarget(Point5d temp) {
            this.target = temp;
        }

        public void setRetract(double retract) {
            this.retract = retract;
        }

        public void setFeedrate(double feedrate) {
            this.feedrate = feedrate;
        }

        public void setDwell(int dwell) {
            this.dwell = dwell;
        }

        public void setPecksize(double pecksize) {
            this.pecksize = pecksize;
        }

        public void doDrill(boolean speedPeck) {
            Base.logger.severe("Drill Cycle code is untested and has therefore been disabled.");
        }
    }
}

